<?php
    session_start();
    // include file
    include_once('easebuzz-lib/easebuzz_payment_gateway.php');
    
    $returnURL = $_SESSION['returnURL'];
    $failedURL = $_SESSION['failedURL'];
    $url;
    //echo '<pre>';print nl2br(print_r($_SESSION, true));echo '</pre>';
    /*
    * Get the API response and verify response is correct or not.
    *
    * params string $easebuzzObj - holds the object of Easebuzz class.
    * params array $_POST - holds the API response array.
    * params string $SALT - holds the merchant salt key.
    * params array $result - holds the API response array after valification of API response.
    *
    * ##Return values
    *
    * - return array $result - hoids API response after varification.
    * 
    * @params string $easebuzzObj - holds the object of Easebuzz class.
    * @params array $_POST - holds the API response array.
    * @params string $SALT - holds the merchant salt key.
    * @params array $result - holds the API response array after valification of API response.
    *
    * @return array $result - hoids API response after varification.
    *
    */
    $easebuzzObj = new Easebuzz($MERCHANT_KEY = null, $SALT, $ENV = null);
    
    $result = $easebuzzObj->easebuzzResponse( $_POST );
    $response = json_decode($result, true);
    
    $status = $response['data']['status'];
    $mrctTxtID = $response['data']['txnid'];
    if($status == 'success'){
        $message = 'Payment_Received';
        if($returnURL){
            $url = $returnURL.'?status='.$status.'&message='.$message.'&mrctTxtID='.$mrctTxtID;
        }else{
            $url = 'https://show.marinersforex.com/flight-booking?status='.$status.'&message='.$message.'&mrctTxtID='.$mrctTxtID;
        }
    }else{
        if($failedURL){
            $url = $failedURL.'?status='.$status.'&message='.$message.'&mrctTxtID='.$mrctTxtID;
        }else{
            $url = 'https://show.marinersforex.com/flight-payment-failed?status='.$status.'&message='.$message.'&mrctTxtID='.$mrctTxtID;
        }
    }
    //echo '<pre>';print nl2br(print_r($response, true));echo '</pre>';exit;
    echo '<script>window.parent.location.href="'.$url.'"</script>';
    exit;
?>

